import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;

class Buecherliste{
  private JFrame f;
  private JTextArea anzeige;
  private JButton ende,btBuecherAnzeigen;
  private JPanel contentpane;
  private JLabel beschriftung;   
  private KlickEmpfaenger klemp;
  private FensterSchliesser fs;
  
  private DatabaseConnector dbcAG;  
  private JList liAGs;
  private DefaultListModel liAGsModel;
  private JScrollPane liAGsScrollPane;
  
  private JTable dbTabelle;
  private DefaultTableModel dbTabelleModel;
  private JScrollPane dbTabelleScrollPane ;
  
  public Buecherliste(){
    f=new JFrame();
    contentpane=new JPanel();
    f.setContentPane(contentpane);    
    contentpane.setLayout(null);
    
    beschriftung=new JLabel();
    beschriftung.setBounds(16, 64, 83, 33);
    beschriftung.setText("AGs:");
    contentpane.add(beschriftung);
    liAGs = new JList();
    liAGsModel = new DefaultListModel();
    liAGsScrollPane = new JScrollPane(liAGs);
    liAGs.setModel(liAGsModel);
    liAGsScrollPane.setBounds(144, 56, 201, 137);
    liAGs.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);  
    dbcAG=new DatabaseConnector("127.0.0.1", 3306,"./lib/AGVerwaltung.db", "", "");
    zeigeAGs();
    klemp=new KlickEmpfaenger(this);
    contentpane.add(liAGsScrollPane);
    
    btBuecherAnzeigen=new JButton();
    btBuecherAnzeigen.setBounds(360, 56, 129, 33);
    btBuecherAnzeigen.setText("Buecher anzeigen");
    btBuecherAnzeigen.setMargin(new Insets(2, 2, 2, 2));
    btBuecherAnzeigen.addActionListener(klemp);      
    contentpane.add(btBuecherAnzeigen);
    
    dbTabelleModel =  new DefaultTableModel();
    dbTabelle = new JTable(dbTabelleModel);       
    dbTabelleModel.addColumn("Titel");
    dbTabelleModel.addColumn("Verfasser");
    dbTabelleModel.addColumn("Anzahl");
    dbTabelleScrollPane = new JScrollPane(dbTabelle);
    dbTabelleScrollPane.setBounds(8, 200, 825, 705);  
    contentpane.add(dbTabelleScrollPane);  
    
    ende=new JButton("Ende");
    ende.addActionListener(klemp);
    ende.setBounds(850,900,129, 33); 
    contentpane.add(ende);
    
    fs=new FensterSchliesser();
    f.addWindowListener(fs);
    f.setSize(1000,1000);
    f.setVisible(true);
  }
  public String aktAG() {
    if (liAGs.getSelectedValue()!=null) {
        return ((String) liAGs.getSelectedValue()).trim();  
    } // end of if
    else {
      return null;
    } // end of if-else
  } 
  
  private void zeigeAGs(){        
    QueryResult ergebnis;
    String[][] daten;
    
    dbcAG.executeStatement("select AGName from AG");
    ergebnis=  dbcAG.getCurrentQueryResult();
    daten= ergebnis.getData();
    for (int i=0; i< ergebnis.getRowCount() ; i++ ) {
      liAGsModel.addElement(daten[i][0]);
    } // end of for    
  } 
  
  public void zeigeBuchListe(List<Buch> li){
    dbTabelleModel =  new DefaultTableModel();
    dbTabelle = new JTable(dbTabelleModel);       
    dbTabelleModel.addColumn("Titel");
    dbTabelleModel.addColumn("Verfasser");
    dbTabelleModel.addColumn("Anzahl");
    dbTabelleScrollPane = new JScrollPane(dbTabelle);
    dbTabelleScrollPane.setBounds(8, 200, 825, 705);  
    contentpane.add(dbTabelleScrollPane);  
    
    li.toFirst();
    while (li.hasAccess()) {
      String[] zeile=new String[3];
      zeile[0]=li.getContent().titel();
      zeile[1]=li.getContent().autor();
      zeile[2]=li.getContent().anzahlLeser()+"";        
      dbTabelleModel.addRow(zeile);
      li.next(); 
    } // end of while
  }
  
  
  public void schliesseDatenbankverbindungundProgramm(){
    dbcAG.close();
    System.exit(0);
  }
  
}
